 ; Ŀ
 ;   Chat/Chab - explode and reblock blocks.                               
 ;   Chat explodes an entity; the entity is then edited and Chab is        
 ;   run which reblocks it.                                                
 ;   Copyright 1995, 2006, 2008 by Rocket Software Ltd.                    
 ;   Why do we assume that subatomic particles are all little spheres?     
 ; 

 ; Ŀ
 ;  Subroutine Gnug - error handler for Chat.lsp.                          
 ; 
 (DEFUN GNUG (shk)
  (if (= shk "Function cancelled.")
      (write-line "\nSuit yourself.")
      (write-line shk))
  (setq *_list savlst)
  (setq *error* prev)
 (princ))
 ; Ŀ
 ;   Gnug end.                                                             
 ; 

 ; Ŀ
 ;  Subroutine Gnag - error handler for Chab.lsp.                          
 ; 
 (DEFUN GNAG (shk)
  (Write-line "Unable to reblock.")
  (entdel aaa)
  (setq *_list savlst)
  (setq *error* prev)
 (princ))
 ; Ŀ
 ;   Gnag end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Nambd - the name by date generator.                        
 ; 
 (DEFUN NAMBD (/ lup exxp)
  (setq lup (getvar "luprec"))
  (setvar "luprec" 8)
  (setq exxp (rtos (getvar "date")))
  (setq exxp (strcat "$X" (substr exxp 11)))
  (setvar "luprec" lup)
 exxp)
 ; Ŀ
 ;   Nambd end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Smack - make an ss of any entities after a given one.      
 ;   Takes the marker ename as an argument, returns an ss.                 
 ;   Note: this routine looks overly baroque.                              
 ; 
 (DEFUN SMACK (aaa / ss bbb)
  (setq ss (ssadd (setq bbb (entnext aaa)))) ; put next ent in new ss
 ; Ŀ
 ;   If the entity is an insert and there are attributes:                  
 ; 
  (if (and (= (cdr (assoc 0 (entget bbb))) "INSERT")
           (= (cdr (assoc 66 (entget bbb))) 1))
 ; Ŀ
 ;   Then find the seqend before assuming entnext will give the next ent.  
 ; 
      (progn
           (while (/= (cdr (assoc 0 (entget bbb))) "SEQEND")
                  (setq bbb (entnext bbb)))))
 ; Ŀ
 ;   Find all entities after the marker point, put them in an ss.          
 ; 
  (while (entnext bbb)                  ; while there are entities
         (setq bbb (entnext bbb))       ; find the next new entity
         (ssadd bbb ss)                 ; add it to the selection set
         (if (and (= (cdr (assoc 0 (entget bbb))) "INSERT")
                  (= (cdr (assoc 66 (entget bbb))) 1))
             (progn
                  (while (/= (cdr (assoc 0 (entget bbb))) "SEQEND")
                         (setq bbb (entnext bbb))))))
  ss)
 ; Ŀ
 ;   Smack end.                                                            
 ; 

 ; Ŀ
 ;   Chab - the reblocker.                                                 
 ; 
 (DEFUN C:CHAB (/ prev *error* datlst namm aaa xscl yscl zscl rota attlst pa
                                                  ss exxp fn layy attval len)
  (setvar "cmdecho" 0)
  (command ".undo" "m")
  (setq prev *error*)
  (setq *error* gnag)
 ; (setq *error* ())
  (setq savlst *_list)
 ; Ŀ
 ;   Extract the required data from the master data list *_list.           
 ; 
  (setq datlst (last *_list))
  (setq namm (nth 0 datlst))
  (setq aaa (nth 1 datlst))
  (setq xscl (nth 2 datlst))
  (setq yscl (nth 3 datlst))
  (setq zscl (nth 4 datlst))
  (setq rota (nth 5 datlst))
  (setq attlst (nth 6 datlst))
  (setq pa (nth 7 datlst))
  (setq elayy (nth 8 datlst))
 ; Ŀ
 ;   Remove the last sublist from *_list.                                  
 ; 
  (setq *_list (reverse (cdr (reverse *_list))))
 ; Ŀ
 ;   Now see if the reblock procedure can be run.                          
 ; 
  (if (/= (type aaa) 'ENAME)
      (write-line "Can't find marker - have you run chat.lsp yet?")
      (progn
 ; Ŀ
 ;   Find all entities after the marker point and make an ss of them.      
 ; 
           (setq ss (smack aaa))
 ; Ŀ
 ;   Call the name by date generator.                                      
 ; 
           (setq exxp (nambd))
 ; Ŀ
 ;   Decide what to call the block.                                        
 ; 
           (cond ((= namm ())
                  (setq fn (getstring
                           "Block name (<Enter> if it doesn't matter): "))
                  (if (/= fn "")
                      (setq namm fn)
                      (setq namm exxp))
                  (command ".block" namm pa ss ""))
                 ((or (= (substr namm 1 2) "*X")
                      (= (substr namm 1 2) "$X"))          ; hatch
                  (setq namm exxp)
                  (command ".block" namm pa ss ""))
 ; Ŀ
 ;   If there is an existing name in the variable Namm.                    
 ; 
                 (T                                        ; standard block
 ; Ŀ
 ;   The commented out stuff is the code to allow the name to be           
 ;   extracted from a selected line of text.  Don't forget the two         
 ;   parenthesis at the end of the getstring line (156).                   
 ; 
;                   (if (and (setq enampt (entsel
;                                       "Select Block Name Text or <Return>: "))
;                            (setq fn (cdr (assoc 1 (entget (car enampt))))))
;                       (princ fn)
;                       (progn
                            (setq fn (strcat
                                         "New block name (<Enter> to redefine "
                                          namm "): "))    ; *
                            (setq fn (getstring fn)) ; )) ; **
                   (if (/= fn "")
                       (progn
                            (setq namm fn)
                            (command ".block" namm pa ss ""))
                       (progn
 ; Ŀ
 ;   The next line was changed so that the reblock didn't crash under R14. 
 ;   Does AutoCAD now not prompt to overwrite during a program?            
 ;   Later: some versions crash, some don't.  This seems likely to be      
 ;   a system variable thing - expert?                                     
 ; 
                            (if (< (getvar "expert") 2)
                                (command ".block" namm "Y" pa ss "")
                                (command ".block" namm pa ss ""))))))
           (setq layy (getvar "clayer"))
           (setvar "clayer" elayy)
           (setvar "attdia" 0)
 ; Ŀ
 ;   Insert the block, put the attributes back in.                         
 ; 
           (command ".insert" namm pa "xyz" xscl yscl zscl rota)
 ; Ŀ
 ;   Fill the attributes with spaces - not all attributes are prompted     
 ;   for on insertion, so it is safer to put them in directly.             
 ; 
           (while (= 1 (getvar "cmdactive")) (command "")) 
           (setq esav (setq enam (entlast)))
           (while (and (setq enam (entnext enam))
                       (/= "SEQEND" (cdr (assoc 0 (setq entt (entget enam)))))
                       (setq tag (car attlst)))
                  (setq attlst (cdr attlst))
                  (entmod (subst (cons 1 tag) (assoc 1 entt) entt)))
           (entupd esav)
 ; Ŀ
 ;   Reset various sysvars etc.                                            
 ; 
           (setvar "attdia" 1)
           (setvar "clayer" layy)
           (entdel aaa)))
  (setq *error* prev)
 ; Ŀ
 ;   See how many inserts there were of the block, say so.                 
 ; 
  (setq len (sslength (ssget "X" (list (cons 2 namm)))))
  (write-line (strcat namm " inserts updated: " (itoa len)))
 (princ))
 ; Ŀ
 ;   Chab end.                                                             
 ; 

 ; Ŀ
 ;   Chat - the dismantler.                                                
 ; 
 (DEFUN C:CHAT (/ prev *error* blip aaa exxp exx ttyp sixsix xscl yscl zscl
                                 rota elayy pa enam entt attlst namm datlst) 
  (setvar "cmdecho" 0)
  (command ".undo" "m")
  (setq prev *error*)
  (setq *error* gnug)
 ; (setq *error* ())
  (setq savlst *_list)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
 ; Ŀ
 ;   Insert and find the marker point, add it to the marker point list.    
 ; 
  (command ".point" "0,0")
  (setvar "blipmode" blip)
  (setq aaa (entlast))
  (setq exxp (car (entsel "Pick entity to detonate: ")))
  (while (null exxp)
         (setq exxp (car (entsel "\nHave another shot, Dead-eye: "))))
  (setq exx (setq ttyp (entget exxp)))
 ; Ŀ
 ;   Get the entity type.                                                  
 ; 
  (setq ttyp (cdr (assoc 0 ttyp)))
 ; Ŀ
 ;   See if there are subentities.                                         
 ; 
  (setq sixsix (assoc 66 exx))
 ; Ŀ
 ;   Get X, Y, and Z scales, assume 1 if not present.                      
 ; 
  (if (setq xscl (assoc 41 exx))
      (progn
           (setq exx (subst (cons 41 1) xscl exx))
           (setq xscl (cdr xscl)))
      (setq xscl 1))
  (if (setq yscl (assoc 42 exx))
      (progn
           (setq exx (subst (cons 42 1) yscl exx))
           (setq yscl (cdr yscl)))
      (setq yscl 1))
  (if (setq zscl (assoc 43 exx))
      (progn
           (setq exx (subst (cons 43 1) zscl exx))
           (setq zscl (cdr zscl)))
      (setq zscl 1))
 ; Ŀ
 ;   Get rotation angle, assume 0 if not present.                          
 ; 
  (if (setq rota (assoc 50 exx))
      (progn
           (setq exx (subst (cons 50 0) rota exx))
           (setq rota (cdr rota))
           (setq rota (* rota (/ 180 pi))))
      (setq rota 0))
  (if (or (/= xscl 1) (/= yscl 1) (/= zscl 1) (/= rota 0))
      (progn
           (entmod exx)
           (cond ((and (or (/= xscl 1) (/= yscl 1)
                           (/= zscl 1)) (/= rotal 0))
                  (setq blip "scale and rotation"))
                 ((or (/= xscl 1) (/= yscl 1) (/= zscl 1))
                  (setq blip "scale"))
                 ((/= rota 0)
                  (setq blip "rotation")))
           (write-line (strcat "Entity " blip
                               " reset to allow correct reblocking."))))
 ; Ŀ
 ;   Save the layer the block was inserted on.                             
 ; 
  (setq elayy (cdr (assoc 8 exx)))
 ; Ŀ
 ;   Get the insertion point.  If the entity is a polyline the insertion   
 ;   will be 0,0,0 so get the next subentity - the first vertex.           
 ; 
  (if (equal ttyp "POLYLINE")
      (progn
           (setq exx (entnext (cdr (assoc -1 exx))))
           (if (null exx)
               (setq pa '(0.0 0.0 0.0))
               (setq pa (cdr (assoc 10 (entget exx))))))
      (setq pa (cdr (assoc 10 exx))))
 ; Ŀ
 ;   If it's a block and there are subentities (attributes) then step      
 ;   through them and save the values.                                     
 ; 
  (setq enam exxp)
  (if (and (= ttyp "INSERT") sixsix)
      (while (/= (cdr (assoc 0 (setq entt (entget (setq enam
                                                  (entnext enam)))))) "SEQEND")
             (setq attlst (append attlst (list (cdr (assoc 1 entt)))))))
 ; Ŀ
 ;   If it's an explodeable entity then do so.                             
 ; 
  (if (or (= ttyp "POLYLINE") (= ttyp "INSERT") (= ttyp "DIMENSION"))
      (progn
 ; Ŀ
 ;   Get the block name (if any), explode the block.                       
 ; 
           (setq namm (cdr (assoc 2 (entget exxp))))
           (command ".explode" exxp))
 ; Ŀ
 ;   Otherwise copy it and delete the original.  This puts the entity      
 ;   after the marker point where Reb can find it.                         
 ; 
      (progn
           (command ".copy" exxp "" "0,0" "0,0")
           (entdel exxp)
           (setq namm ())
           (redraw (entlast))))
 ; Ŀ
 ;   Make the data list, append it to the master list of data lists.       
 ; 
  (setq datlst (list namm aaa xscl yscl zscl rota attlst pa elayy))
  (setq *_list (append *_list (list datlst)))
 ; Ŀ
 ;   Print further instructions, reset error handler, end.                 
 ; 
  (write-line "\nRun Chab.lsp to reblock.")
  (setq *error* prev)
 (princ))